<?php
/**
 * Veidotājs: Roberts Blite
 * Mērķis: Šis PHP skripts ļauj valdes loceklim pārvaldīt un apskatīt darbinieku darba stundas.
 * Apraksts: Skripts pārbauda, vai lietotājs ir valdes loceklis, un ļauj viņam iegūt darbinieku sarakstu,
 *           kā arī konkrēta darbinieka darba stundas.
 */

// Datubāzes savienojuma parametri
$servername = "database-1.cd0m46mqkm83.eu-north-1.rds.amazonaws.com";
$username = "admin";
$password = "HyperX3146!";
$dbname = "rb_kvalif_410";

// Izveido savienojumu ar datubāzi
$conn = new mysqli($servername, $username, $password, $dbname);

// Pārbauda savienojumu
if ($conn->connect_error) {
    die(json_encode(["error" => "Savienojums ar datubāzi neizdevās: " . $conn->connect_error]));
}

session_start(); // Sāk sesiju, lai iegūtu lietotāja informāciju
header('Content-Type: application/json'); // Iestata atbildes tipu kā JSON

// Iegūst lietotāja ID un lomu no sesijas
$user_id = $_SESSION['user_id'] ?? null;
$role = $_SESSION['work_position'] ?? null;
$action = $_GET['action'] ?? $_POST['action'] ?? null;

// Pārbauda, vai lietotājs ir autorizēts un ir valdes loceklis
if (!$user_id || $role !== 'valdes_loceklis') {
    echo json_encode(["error" => "Piekļuve liegta."]);
    exit;
}

// Iegūst darbiniekus nolaižamajai izvēlnei
if ($action === "fetch-workers") {
    $sql = "SELECT id, first_name, last_name FROM rb_kvalif_signup_410 WHERE work_position = 'darbinieks'";
    $result = $conn->query($sql);

    if ($result) {
        echo json_encode(["data" => $result->fetch_all(MYSQLI_ASSOC)]);
    } else {
        echo json_encode(["error" => "Neizdevās iegūt darbiniekus: " . $conn->error]);
    }
    exit;
}

// Iegūst izvēlētā darbinieka darba stundas
elseif ($action === "fetch-work-hours") {
    $worker_id = $_GET['worker_id'] ?? null;

    // Pārbauda, vai darbinieka ID ir norādīts
    if (!$worker_id) {
        echo json_encode(["error" => "Nepieciešams darbinieka ID."]);
        exit;
    }

    // SQL vaicājums, lai iegūtu darba stundas
    $sql = "SELECT date, clock_in_time, 
                   IF(clock_out_time IS NULL, 'Nav pieejams', clock_out_time) AS clock_out_time,
                   IF(clock_out_time IS NULL, 'Procesā', FORMAT(total_work_hours, 2)) AS total_work_hours
            FROM rb_kvalif_workhours_410 
            WHERE user_id = ? ORDER BY date DESC";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $worker_id);
    $stmt->execute();
    echo json_encode(["data" => $stmt->get_result()->fetch_all(MYSQLI_ASSOC)]);
    exit;
}

// Ja darbība nav norādīta vai ir nederīga
echo json_encode(["error" => "Nepareiza darbība."]);

// Aizver datubāzes savienojumu
$conn->close();
?>
